<?php /* Template Name: loop-events */ ?>
<section id="events">
<div id="content">
<div class="container">

<hgroup>
    <h1><div class="icon"></div><span class="title">Events</span></h1>
    <div class="banner">Latest scopes</div>
</hgroup>
 <div class="main">
<!--First I made a header and tried to make dropdowns-->
 <table id="dropdown">
<tr>
   <th class="eventimg">Img</th>
   <th class="date">Date</th>
   <th class="event drop"> Events<div class="dropdown"><?php wp_nav_menu('menu=events'); ?></div></th>
  	<th class="location">Venue<div class="dropdown"><?php wp_nav_menu('menu=venues'); ?> </div></th>
    <th class="country drop">Country <div class="dropdown">Countries</div></th>
    <th class="category drop">Categories<div class="dropdown"><?php wp_nav_menu('menu=categories'); ?></div></th>
    </tr>
</table>

<!--Here comes the loop with tribe_events post type-->
<?php $loop = new WP_Query( array( 'post_type' => 'tribe_events', 'posts_per_page' => 10, 'orderby' => 'date', 'order' => 'ASC', 'paged' ) ); ?>

<!--Upcoming events-->
<table id="list">
<tr>
<?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
<?php get_post_meta($post->ID, 'events', true); ?>

    	<td class="eventimg"><a href="<?php the_permalink(); ?>"><?php if ( has_post_thumbnail() ) the_post_thumbnail('small-list-thumbnail'); ?></a></td >
        <td class="date"><?php echo tribe_get_start_date( null, false, 'd.m' ); ?> </span>
        <td class="event">	<?php the_title('<a href="' . tribe_get_event_link() . '" title="' . the_title_attribute('echo=0') . '" rel="bookmark">', '</a>'); ?> </td >
        <td class="location"> <?php  $venue = tribe_get_venue();  if ( !empty( $venue ) ) : ?><?php echo $venue; ?> <?php endif; ?></td >
        <td class="country"> <?php  $country = tribe_get_country();  if ( !empty( $country ) ) : ?><?php echo $country; ?> <?php endif; ?></td >
        <td class="category"> <?php $category = tribe_meta_event_cats(' ',', '); if ( !empty( $category ) ) :?><?php echo $category; ?><?php endif; ?></td >
        </tr>

<?php endwhile; ?>
 </table>
</div><!--End main-->
<div class="main">
</div>
</div><!--End Container-->

<?php get_sidebar('events'); ?>
<div class="clear"></div>
</section>
