<?php
/**
 * Events List Widget Template
 * This is the template for the output of the events list widget.
 * All the items are turned on and off through the widget admin.
 * There is currently no default styling, which is needed.
 *
 * This view contains the filters required to create an effective events list widget view.
 *
 * You can recreate an ENTIRELY new events list widget view by doing a template override,
 * and placing a list-widget.php file in a tribe-events/widgets/ directory
 * within your theme directory, which will override the /views/widgets/list-widget.php.
 *
 * You can use any or all filters included in this file or create your own filters in
 * your functions.php. In order to modify or extend a single filter, please see our
 * readme on templates hooks and filters (TO-DO)
 *
 * @return string
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
$event_id = get_the_ID();
$events_label_plural = tribe_get_event_label_plural();
$dimension = 90;
$dimensionh = 80;
$posts = tribe_get_list_widget_events();

// Check if any event posts are found.
if ( $posts ) : ?>

	<ol class="tribe-list-widget">
		<?php
		// Setup the post data for each event.
		foreach ( $posts as $post ) :
			setup_postdata( $post );
			$image_src_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full', true);
        $image_src       = bfi_thumb($image_src_array[0], array(
            'width' => $dimension,
            'height' => $dimensionh,
            'crop' => true
        ));
			?>
			<li class="tribe-events-list-widget-events <?php tribe_events_event_classes() ?>">
				<?php do_action( 'tribe_events_list_widget_before_the_event_thumb' ); ?>
				<!-- Event Title -->
				<div class="tribe-event-thumb">
					<img style="" alt="<?php echo  get_the_title(); ?>"  title="<?php echo get_the_title(); ?>" src="<?php echo helpme_thumbnail_image_gen($image_src, $dimension, $dimensionh); ?>" />
				</div>

				<?php do_action( 'tribe_events_list_widget_after_the_event_thumb' ); ?>
				<div class="tribe-event-content">
				<?php do_action( 'tribe_events_list_widget_before_the_event_title' ); ?>
				<!-- Event Title -->
				<h5 class="tribe-event-title">
					<a href="<?php echo esc_url( tribe_get_event_link() ); ?>" rel="bookmark"><?php the_title(); ?></a>
				</h5>

				<?php do_action( 'tribe_events_list_widget_after_the_event_title' ); ?>
				<!-- Event Time -->

				<?php do_action( 'tribe_events_list_widget_before_the_meta' ) ?>

				<div class="tribe-event-duration">
					<?php echo tribe_events_event_schedule_details(); ?>
				</div>

				<?php do_action( 'tribe_events_list_widget_after_the_meta' ) ?>
				</div>
				<div class="clearboth"></div>
			</li>
		<?php
		endforeach;
		?>
	</ol><!-- .tribe-list-widget -->



<?php
// No events were found.
else : ?>
	<p><?php printf( esc_html__( 'No hay próximos eventos %s hasta ahora.', 'the-events-calendar' ), strtolower( $events_label_plural ) ); ?></p>
<?php
endif;
